//Dustin Soodak




//Rotate with gyroscope
//Assumes that direction it is pointing at startup is zero degrees
//Type desired heading, then it will turn until it thinks it will
//skid (with motors off) to approximately that direction. 
#include "Navigation.h"
#include "MiscHardware.h"//for HardwareBegin(),SwitchSerialToMotors(),SwitchMotorsToSerial(),RestartTimer(),GetTime(), 
void setup(){
  HardwareBegin();
  //Serial.begin(38400);//removed since HardwareBegin() includes all of the other initialization functions
  Serial.println("type # of degrees followed by ENTER, then press button to turn.");
  delay(1000);//make sure not moving robot when NavigationBegin() since it also zeroes the sensors
  NavigationBegin();//initialize and start navigation
  RestartTimer();
}
int PrintDelay=200;
int Turn=0;
int deg;//to store degrees and degress per second
String NumString = "";
int ch;
int TargetDegrees,DegrMotorStarted=0,DegrMotorStopped=0,DegrPredict, DegrMotorSkid, DPSAtSkid;
int dir;
void loop(){
  SimpleGyroNavigation();
  deg=GetDegrees();
  if(Serial.available() > 0){
    ch = Serial.read();    
    if (isDigit(ch) || ch=='-'){
      NumString += (char)ch;  
    }
    if(ch=='\n'){      
      TargetDegrees=NumString.toInt();  
      DegrMotorStarted=0;DegrMotorStopped=0;//just so we know if we haven't tried turning since new setting
      NumString="";
    }
  }//end if(Serial.available() > 0)
  
  if(GetTime()>PrintDelay){
    if(GyroFifoOverflow)//happens if SimpleGyroNavigation() not called often enough
      Serial.print("overflow ");   
    Serial.print("Started ");
    Serial.print(DegrMotorStarted,DEC);
    Serial.print(" stopped ");
    Serial.print(DegrMotorStopped,DEC);
    Serial.print(" (");
    Serial.print(DPSAtSkid,DEC);//degrees per second
    Serial.print(" dps), skidded to ");
    Serial.print(DegrMotorSkid,DEC);    
    Serial.print(", target ");//in absolute degrees, not relative to start position for this rotation
    Serial.print(TargetDegrees,DEC);

    Serial.print(", current: "); 
    Serial.println(deg,DEC);
    
    RestartTimer(); 
  }//end if(GetTime()>PrintDelay)
  
  SwitchPixelsToButton();
  if(ButtonPressed()){
    delay(10);//debounce button
    while(ButtonPressed())
      SimpleGyroNavigation();
    RestartTimer();
    while(GetTime()<500){//to let user get finger away
      SimpleGyroNavigation();
    } 
    DegrMotorStarted=GetDegrees();
    SwitchButtonToPixels();
    SetPixelRGB(5,0,50,0);SetPixelRGB(6,0,50,0);RefreshPixels();
    SwitchSerialToMotors();
    if(TargetDegrees>DegrMotorStarted){
      Motors(150,-150);
      dir=1;
    }
    else if(TargetDegrees<DegrMotorStarted){
      Motors(-150,150); 
      dir=-1;
    }    
    RestartTimer();
    while(GetTime()<3000){//3000 = 3 second timeout
      SimpleGyroNavigation();
      deg=GetDegrees();   
      DegrPredict=deg+GetDegreesToStop(); //DegrPredict=degr+GyroDegreesToStopFromRaw(rate);//(((float)(-rate))*2000/32768)*0.1029-(24);        
      if(dir>=0?(DegrPredict>=TargetDegrees):(DegrPredict<=TargetDegrees)){ 
        DPSAtSkid=GetDegreesPerSecond();
        break; 
      }
    }
    Motors(0,0);
    DegrMotorStopped=GetDegrees();   
    SwitchButtonToPixels();
    SetPixelRGB(5,50,0,0);SetPixelRGB(6,50,0,0);RefreshPixels();
    RestartTimer();
    while(GetTime()<500){//to let it skid to a halt
      SimpleGyroNavigation();
    } 
    DegrMotorSkid=GetDegrees();
    SetPixelRGB(5,0,0,0);SetPixelRGB(6,0,0,0);RefreshPixels();   
    SwitchMotorsToSerial();  
    RestartTimer();   
  }//end if(ButtonPressed()
  
}


